﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HL7MessageLogGetPendingForPatient]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HL7MessageLogGetPendingForPatient]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 15 Jan 2016
-- Description: Gets all pending items from the HL7MessageLog table for a specific patient
-- =============================================
CREATE PROCEDURE [hips].[HL7MessageLogGetPendingForPatient] 
(
		 @HospitalPatientIdentifier varchar(20),
		 @HospitalId int,
		 @MessageDateTime datetime,
		 @UseHL7MessageDateTime bit = 1    
) AS
BEGIN

SELECT 	[HL7MessageLogId]
       ,[HospitalId]
       ,[HospitalPatientIdentifier]
       ,[SendingApplication]
       ,[SendingFacility]
       ,[MessageControlId]
       ,[DateTimeOfMessage]
       ,[QueueStatusId]
       ,[ShouldRetry]
       ,[RetryCount]
       ,[FailureReason]
       ,[FullMessage]
       ,[DateCreated]
       ,[UserCreated]
       ,[DateModified]
       ,[UserModified]
FROM [hips].[HL7MessageLog] 
WHERE HospitalPatientIdentifier = @HospitalPatientIdentifier
	AND HospitalId = @HospitalId
	AND QueueStatusId = 1 -- Pending
	AND ((@UseHL7MessageDateTime = 1 AND DateTimeOfMessage < @MessageDateTime)
		OR (DateCreated < @MessageDateTime))

END
GO
GRANT EXEC ON [hips].[HL7MessageLogGetPendingForPatient] TO RunStoredProcedure
GO